
desktopDirectory = '/Users/gfivash/Desktop/'
setwd(desktopDirectory)
dir(pattern = '.csv')

col = NA
col[1:4] = 'green'
col[6] = 'blue'
col[5] = 'yellow'
duration.hr = c()
maxDepth.cm = c()
sedimentShape = c()
sedimentShape_i = c(rep('flat',times = 4),'hollow','hummock')
counter = 1
for(i in c(1,5,6)){
#for(i in c(6,1,5)){
  file = dir(pattern = '.csv')[i]
  d = read.csv(file)
  
  i_tide = 1
  for(i_tide in 1:max(d$tide.ID, na.rm = T)){
    filter = d$tide.ID == i_tide
    plot(d$oxygen50.cm[filter] ~ d$tideTime[filter], 
         main = i,
         ylim = c(6,-1), lwd = 3, type = 'l', cex = 3, col = alpha(col[i],0.5))
   
    
    threshold = 0.15
    lines(x = c(0,12), y = c(threshold,threshold))
    if(length(d$tideTime[d$oxygen50.cm > threshold  & d$tide.ID == i_tide & d$tideTime < 6]) == 0){
      duration.hr[counter] = 0  
    } else {
      duration.hr[counter] = max(d$tideTime[d$oxygen50.cm > threshold  & d$tide.ID == i_tide & d$tideTime < 6], na.rm = T)
    }
    maxDepth.cm[counter] = max(d$oxygen50.cm[filter], na.rm = T)
    lines(x = c(max[counter],max[counter]), y = c(-1,6), lty = 2)
    sedimentShape[counter] = sedimentShape_i[i]
    counter = counter + 1
  }
}

col = c('yellow','green','blue')
sedimentShape = factor(sedimentShape, levels = c("hollow",'flat','hummock'))

plot(duration.hr ~ sedimentShape, ylim = c(0, 6), col = alpha(c('yellow','green','blue'),0.5))
points(duration.hr ~ sedimentShape, pch = 21, bg = alpha(col[sedimentShape],0.5))

plot(maxDepth.cm ~ sedimentShape, ylim = c(0, 6), col = alpha(c('yellow','green','blue'),0.5))
points(maxDepth.cm ~ sedimentShape, pch = 21, bg = alpha(col[sedimentShape],0.5))

mean(max[sedimentShape == 'hollow'])
sd(max[sedimentShape == 'hollow'])
mean(max[sedimentShape == 'flat'])
sd(max[sedimentShape == 'flat'])
mean(max[sedimentShape == 'hummock'])
sd(max[sedimentShape == 'hummock'])

m = aov(duration.hr ~ sedimentShape)
anova(m)
TukeyHSD(m)

m = aov(maxDepth.cm ~ sedimentShape)
anova(m)
TukeyHSD(m)

for(i in c(4)){
  file = dir(pattern = '.csv')[i]
  
  d = read.csv(file)
  plot(d$oxygen50.cm ~ d$tideTime, ylim = c(6,-1), pch = '.', cex = 3)
  lines(x = c(0,12), y = c(threshold,threshold))
  max[counter] = max(d$tideTime[d$oxygen50.cm > threshold & d$tideTime < 6], na.rm = T)
  sedimentShape[counter] = as.character(unique(d$sedimentShape))
  counter = counter + 1
  
}

setwd(desktopDirectory)
write.csv(d, file, row.names = F)



